@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Daftar Hasil Pemeriksaan</h1>
                    <p class="text-gray-600 mt-1">Kelola hasil pemeriksaan pasien</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.patients.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Daftar Pasien
                    </a>
                    <a href="{{ route('admin.exam-results.create') }}" 
                       class="bg-[#192D50] text-white px-4 py-2 rounded-none hover:bg-[#8B8B8B] transition duration-150">
                        Tambah Hasil
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Search and Filter -->
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                <div class="p-6">
                    <form method="GET" action="{{ route('admin.exam-results.index') }}" class="space-y-4">
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                            <!-- Search Input -->
                            <div>
                                <label for="search" class="block text-sm font-medium text-gray-700 mb-2">Cari</label>
                                <input type="text" id="search" name="search" 
                                       value="{{ request('search') }}"
                                       placeholder="Cari berdasarkan nama pasien, email, MRN, jenis pemeriksaan..."
                                       class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                            </div>
                            
                            <!-- Status Filter -->
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                                <select id="status" name="status" 
                                        class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    <option value="">Semua Status</option>
                                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                                    <option value="failed" {{ request('status') == 'failed' ? 'selected' : '' }}>Failed</option>
                                </select>
                            </div>
                            
                            <!-- Exam Type Filter -->
                            <div>
                                <label for="exam_type" class="block text-sm font-medium text-gray-700 mb-2">Jenis Pemeriksaan</label>
                                <select id="exam_type" name="exam_type" 
                                        class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    <option value="">Semua Jenis</option>
                                    <option value="mcu" {{ request('exam_type') == 'mcu' ? 'selected' : '' }}>MCU</option>
                                    <option value="lab" {{ request('exam_type') == 'lab' ? 'selected' : '' }}>Lab</option>
                                    <option value="radiologi" {{ request('exam_type') == 'radiologi' ? 'selected' : '' }}>Radiologi</option>
                                    <option value="konsultasi" {{ request('exam_type') == 'konsultasi' ? 'selected' : '' }}>Konsultasi</option>
                                </select>
                            </div>
                            
                            <!-- Action Buttons -->
                            <div class="flex items-end space-x-2">
                                <button type="submit" 
                                        class="px-4 py-2 bg-[#192D50] text-white rounded-none hover:bg-[#8B8B8B] transition duration-150">
                                    <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                    </svg>
                                    Cari
                                </button>
                                <a href="{{ route('admin.exam-results.index') }}" 
                                   class="px-4 py-2 bg-gray-600 text-white rounded-none hover:bg-gray-700 transition duration-150">
                                    Reset
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Total Hasil</p>
                                <p class="text-2xl font-semibold text-gray-900">{{ $examResults->total() }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#8B8B8B] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Selesai</p>
                                <p class="text-2xl font-semibold text-gray-900">{{ $examResults->where('status', 'completed')->count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Pending</p>
                                <p class="text-2xl font-semibold text-gray-900">{{ $examResults->where('status', 'pending')->count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Gagal</p>
                                <p class="text-2xl font-semibold text-gray-900">{{ $examResults->where('status', 'failed')->count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                <div class="p-6 text-gray-900">
                    <div class="flex justify-between items-center mb-6">
                        <div>
                            <h3 class="text-lg font-medium text-gray-900">Data Hasil Pemeriksaan</h3>
                            @if(request('search') || request('status') || request('exam_type'))
                                <div class="mt-2">
                                    <p class="text-sm text-gray-600">
                                        Menampilkan {{ $examResults->count() }} dari {{ $examResults->total() }} hasil pemeriksaan
                                        @if(request('search'))
                                            untuk pencarian "{{ request('search') }}"
                                        @endif
                                        @if(request('status'))
                                            dengan status {{ ucfirst(request('status')) }}
                                        @endif
                                        @if(request('exam_type'))
                                            jenis {{ ucfirst(request('exam_type')) }}
                                        @endif
                                    </p>
                                </div>
                            @endif
                        </div>
                        <a href="{{ route('admin.exam-results.create') }}" 
                           class="inline-flex items-center px-4 py-2 bg-[#192D50] border border-transparent rounded-none font-semibold text-xs text-white uppercase tracking-widest hover:bg-[#8B8B8B] focus:bg-[#8B8B8B] active:bg-[#192D50] focus:outline-none focus:ring-2 focus:ring-[#CBB4B0] focus:ring-offset-2 transition ease-in-out duration-150">
                            Tambah Hasil
                        </a>
                    </div>

                    @if($examResults->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-[#192D50]">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Subjek</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jenis Pemeriksaan</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-[#F6F6F6] divide-y divide-[#CBB4B0]">
                                    @foreach($examResults as $result)
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                @if($result->patient)
                                                    <div class="text-sm font-medium text-gray-900">{{ $result->patient->name }}</div>
                                                    <div class="text-sm text-gray-500">{{ $result->patient->email }}</div>
                                                    <div class="text-xs text-gray-400">Pasien</div>
                                                @elseif($result->employee)
                                                    <div class="text-sm font-medium text-gray-900">{{ $result->employee->name }}</div>
                                                    <div class="text-sm text-gray-500">{{ $result->employee->company->name ?? 'N/A' }}</div>
                                                    <div class="text-xs text-gray-400">Karyawan</div>
                                                @elseif($result->partner)
                                                    <div class="text-sm font-medium text-gray-900">{{ $result->partner->name }}</div>
                                                    <div class="text-sm text-gray-500">{{ $result->partner->code }}</div>
                                                    <div class="text-xs text-gray-400">Rekanan</div>
                                                @else
                                                    <div class="text-sm font-medium text-gray-900">Tidak Diketahui</div>
                                                    <div class="text-sm text-gray-500">-</div>
                                                    <div class="text-xs text-gray-400">-</div>
                                                @endif
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ ucfirst($result->exam_type) }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $result->exam_date->format('d/m/Y') }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                                    @if($result->status == 'completed') bg-[#8B8B8B] text-white
                                                    @elseif($result->status == 'pending') bg-[#192D50] text-white
                                                    @else bg-[#192D50] text-white @endif">
                                                    {{ ucfirst($result->status) }}
                                                </span>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                <a href="{{ route('admin.exam-results.show', $result) }}" 
                                                   class="inline-flex items-center px-3 py-1 border border-transparent text-xs font-medium rounded text-[#CBB4B0] bg-[#F6F6F6] hover:bg-[#192D50] hover:text-white transition duration-150">
                                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                                    </svg>
                                                    Detail
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-6">
                            {{ $examResults->links() }}
                        </div>
                    @else
                        <div class="text-center py-8">
                            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-gray-100">
                                <svg class="h-6 w-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                            </div>
                            <h3 class="mt-4 text-lg font-medium text-gray-900">Belum Ada Hasil Pemeriksaan</h3>
                            <p class="mt-2 text-sm text-gray-600">
                                Belum ada data hasil pemeriksaan yang tersedia.
                            </p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
